# -*- coding: utf-8 -*-
"""
Created on Thu Apr 18 12:55:31 2024

@author: 123
"""

import re
import os
import pandas as pd
import numpy as np

blb_data=pd.read_csv("J:\\BJ MWR\\tiqu0820\\blb_all_08_20_wukong.csv")
irt_data=pd.read_csv("J:\\BJ MWR\\tiqu0820\\irt_5T_all08_20_wukong.csv")
lwp_data=pd.read_csv("J:\\BJ MWR\\tiqu0820\\lwp_5T_all08_20_wukong.csv")

brt_data=pd.read_csv("J:\\BJ MWR\\tiqu0820\\brt_5T_all08_20_wukong.csv")
met_data=pd.read_csv("J:\\BJ MWR\\tiqu0820\\met_5T_all08_20_wukong.csv")
# 将索引转换为时间类型

blb_data.set_index('Timestamp', inplace=True)
blb_data.index = pd.to_datetime(blb_data.index)
irt_data.set_index('Timestamp', inplace=True)
irt_data.index = pd.to_datetime(irt_data.index)
lwp_data.set_index('Timestamp', inplace=True)
lwp_data.index = pd.to_datetime(lwp_data.index)

met_data.set_index('Timestamp', inplace=True)
met_data.index = pd.to_datetime(met_data.index)
brt_data.set_index('Timestamp', inplace=True)
brt_data.index = pd.to_datetime(brt_data.index)


folder_path = "D:\\guo\\RS-BNU\\bj\\mwr+tk\\"

# 获取文件夹内所有CSV文件的文件名
csv_files = [file for file in os.listdir(folder_path) if file.endswith('.csv')]

blbls = blb_data.columns[6:]
irtls = irt_data.columns[7:8]
lwpls = lwp_data.columns

metls = met_data.columns
brtls = brt_data.columns

combined_index0= metls.append(brtls)
combined_index1= combined_index0.append(blbls)
combined_index2= combined_index1.append(irtls)
combined_index3= combined_index2.append(lwpls)
  
#columns_index待改

# # 循环读取每个CSV文件并将其合并到merged_data中
for csv_file in csv_files:
    file_path = os.path.join(folder_path, csv_file)
    name=csv_file[0:10]
    tktime = pd.to_datetime(name, format='%Y%m%d%H')
      
    #仅保留数据 blb缺失跳过待改try
    try:
        # print(csv_file)
        met=met_data.loc[tktime].to_frame()
        met_values=met.values.T
           
        blb=blb_data.loc[tktime].to_frame()
        blb_values=blb.values.T
        blb_values=blb_values[:,6:]
        
        irt=irt_data.loc[tktime].to_frame()
        irt_values=irt.values.T
        irt_values=irt_values[:,7:8]
        
        lwp=lwp_data.loc[tktime].to_frame()
        lwp_values=lwp.values.T
                
        brt=brt_data.loc[tktime].to_frame()
        brt_values=brt.values.T
        rainflag=met.iloc[8,0] 
        RR=met.iloc[3,0]
        
        
        print('添加'+csv_file)
        data=pd.read_csv(file_path)
        data['temperature'] += 273.15
        a=data.shape[0]
        #复制行数
        blb_2d = np.tile(blb_values, (a, 1))
        irt_2d = np.tile(irt_values, (a, 1))
        lwp_2d = np.tile(lwp_values, (a, 1))
        
        met_2d = np.tile(met_values, (a, 1))
        brt_2d = np.tile(brt_values, (a, 1))
        
        # result_2d_0 = np.concatenate((data,met_2d), axis=1)
        result_2d_1 = np.concatenate((met_2d,brt_2d), axis=1)
        result_2d_2 = np.concatenate((result_2d_1, blb_2d), axis=1)
        result_2d_3 = np.concatenate((result_2d_2, irt_2d), axis=1)
        result_2d_4 = np.concatenate((result_2d_3, lwp_2d), axis=1)
        resultls=pd.DataFrame(result_2d_4,columns=combined_index3)   
        # resultls=pd.DataFrame(result_2d,columns=combined_index0)
        resultls = resultls.reset_index(drop=True)
        data = data.reset_index(drop=True)
        resultall = pd.concat([data, resultls], axis=1)
            
        resultall.to_csv("D:\\guo\\RS-BNU\\bj\\all+met+brt+blb+irt+lwp\\"+csv_file,index=False,encoding='utf-8')
    except KeyError:
        print('缺失'+csv_file)



#### 探空++mwrlv1+mwrsurface+mwrlv2+mmcrlv1

    
    
    
    
    
    
    